/* 
    Projekt: Automatisches Bewässerungssystem 
    Studiengang: Mechatronik
    GET-Fachpraktikum
    Datum: 12.12.2023
    Autor: Jürgen Heimann

*/


#include "pflanzentopf.h"
#include "wassertank.h"

#include <LiquidCrystal.h>

// Zustände
#define STATE_WARTEN 1
#define STATE_BODENFEUCHTE_MESSEN 2
#define STATE_PFLANZE_BEWAESSERN 3
#define STATE_WASSERTANK_LEER 4
byte state = STATE_WARTEN;



// Variablen Wartezeit
int LETZTE_ZEITMESSUNG = 0;
const int WARTEZEIT_ZEITMESSUNG = 2000; // in ms


// LCD Display
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

void zeigeMesswerte(String status) {
  double bodenfeuchte = messeBodenfeuchte();
  double fuellstandTank = messeFuellstandTank();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(String(bodenfeuchte, 2) + " %" + " " + status);
  lcd.setCursor(0, 1);
  lcd.print(String(fuellstandTank, 2) + " cm" + " " + status);
}

void zeigeWassertankLeer() {
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Wassertank");
  lcd.setCursor(0, 1);
  lcd.print("leer");
}



void setup() {
  Serial.begin(9600);
  Serial.print("Starte Bewässerungssystem");

  initBodenfeuchteSensor();
  initUltraschallSensor();
  initPumpe();
  
  lcd.begin(16, 2);
  lcd.clear();
  
  lcd.setCursor(0, 0);
  lcd.print("Starte");
  lcd.setCursor(0, 1);
  lcd.print("Bewaesserung");
  

  delay(2000);

  lcd.clear();

}

void loop() {

  switch(state) {
    case STATE_WARTEN: {
      // WENN ZEIT ABGELAUFEN IST -> BODENFEUCHTE MESSEN
      if (millis() - LETZTE_ZEITMESSUNG > WARTEZEIT_ZEITMESSUNG) {
        LETZTE_ZEITMESSUNG = millis();
        state = STATE_BODENFEUCHTE_MESSEN;
        Serial.println("STATE <STATE_BODENFEUCHTE_MESSEN>");
      }
    } break;
    case STATE_BODENFEUCHTE_MESSEN: {

      // WENN BODENFEUCHTE ZU GERING -> PFLANZE BEWÄSSERN
      // WENN BODENFEUCHTE AUSREICHEND -> ERNEUT WARTEN
      if (istBodenfeucheZuGering() == true){
        state = STATE_PFLANZE_BEWAESSERN;
        starteBewaesserung();
        Serial.println("STATE <STATE_PFLANZE_BEWAESSERN>");
      } else {
        LETZTE_ZEITMESSUNG = millis();
        state = STATE_WARTEN;
        Serial.println("STATE <STATE_WARTEN>");
      }
    } break;
    case STATE_PFLANZE_BEWAESSERN: {

      // WENN FÜLLSTAND DES WASSERTANK ZU GERING -> WARTEN AUF AUFFÜLLEN
      if (istFuellstandTankZuGering() == true) {
        stoppeBewaesserung();
        state = STATE_WASSERTANK_LEER;
        Serial.println("STATE <STATE_WASSERTANK_LEER>");
      }

      // WENN PFLANZE AUSREICHEND GEGOSSEN -> ERNEUT WARTEN
      if (istPflanzeAusreichendGegossen() == true) {
        stoppeBewaesserung();
        LETZTE_ZEITMESSUNG = millis();
        state = STATE_WARTEN;
        Serial.println("STATE <STATE_WARTEN>");
      }
    } break;
    case STATE_WASSERTANK_LEER: {
      // WENN FÜLLSTAND DES WASSERTANK NICHT MEHR ZU GERING -> ERNEUT WARTEN
      if (istFuellstandTankZuGering() == false) {
        LETZTE_ZEITMESSUNG = millis();
        state = STATE_WARTEN;
        Serial.println("STATE <STATE_WARTEN>");
      }
    } break;
  }

switch(state) {
    case STATE_WARTEN: {
      zeigeMesswerte("W");
    } break;
    case STATE_BODENFEUCHTE_MESSEN: {
      zeigeMesswerte("M");
    } break;
    case STATE_PFLANZE_BEWAESSERN: {
      zeigeMesswerte("B");
    } break;
    case STATE_WASSERTANK_LEER: {
      zeigeWassertankLeer();
    } break;
  }


}




